#if !defined(SSTVENG_H)
#define SSTVENG_H

#if UseLIB      // To use a LIB file
#define	FUNCHEAD	extern "C" __declspec( dllimport )
#define	FUNCTYPE	__stdcall
#else           // To use GetProcAddress() Windows API
#define	FUNCHEAD	typedef
#define	FUNCTYPE	__stdcall *
#endif

// mmsDoJob()
#define jcUpdateRX  0x00000001
#define jcRX        0x00000002
#define jcStartRX   0x00000004
#define jcTX        0x00000008
#define jcFSKID     0x00000010
#define jcSpec      0x00000020
#define jcRadioFreq 0x00000040
#define jcDetRep    0x00000080
#define jcDetTone   0x00000100
#define	jcTick		0x00000200

// mmsSetRxControl()
#define rcFSKID     0x00000001
#define rcAFC       0x00000002
#define rcLMS       0x00000004
#define rcAutoRestart 0x00000008
#define rcAutoStop  0x00000010
#define rcAutoSync  0x00000020
#define rcAutoSlant 0x00000040
#define rcAutoClear 0x00000080
#define	rcFirstSync	0x00030000
#define	rcUseBuff	0x00300000
#define	rcDemType	0x03000000
#define	rcBPF		0x30000000

// mmsSetTxControl()
#define tcFSKID     0x00000001
#define tcCWID      0x00000002
#define tcECHO      0x00030000

// mmsSetTuneControl()
#define	ucGAIN		0x00000007
#define	ucTYPE		0x00000030
#define	ucRESP		0x00000300
#define	ucPERSIST   0x00003000
#define	ucAGC		0x00010000
#define	ucLSYNC		0x00100000
#define ucPRIORITY  0x30000000

// mmsDisableOption()
#define doPTT       0x00000001
#define doRadio     0x00000002
#define doVari      0x00000004
#define doFSKID     0x00000008
#define doCWID      0x00000010
#define doSpecCol   0x00000020
#define doWaterCol  0x00000040
#define doAutoSlant 0x00000080
#define doAutoClear 0x00000100

// Messages
enum {
    TXMS_WAVE,
    TXMS_PTT,
    TXMS_SCAN,
    TXMS_FSKID,
    TXMS_DETREP,
    TXMS_CWID,
    TXMS_CLOCKCHANGE,
};

typedef long LONG;
typedef unsigned long ULONG;
typedef long* LPLONG;
typedef RECT* LPRECT;
typedef WCHAR* LPWSTR;
// CWID callback
typedef void (CALLBACK *CWIDPROC)(LPSTR, LONG, LPCSTR);

// Functions
FUNCHEAD LPCSTR (FUNCTYPE mmsGetVersion)(void);
FUNCHEAD LONG (FUNCTYPE mmsLanguage)(LONG lang);
FUNCHEAD BOOL (FUNCTYPE mmsCreate)(HWND hWnd, ULONG msg);
FUNCHEAD void (FUNCTYPE mmsDelete)(void);
FUNCHEAD void (FUNCTYPE mmsStart)(void);
FUNCHEAD void (FUNCTYPE mmsStop)(void);
FUNCHEAD LONG (FUNCTYPE mmsOption)(void);
FUNCHEAD void (FUNCTYPE mmsSetOptionTitle)(LPCSTR pTitle);
FUNCHEAD LONG (FUNCTYPE mmsSetBitmap)(HBITMAP hRX, HBITMAP hSync, HBITMAP hTX);
FUNCHEAD LONG (FUNCTYPE mmsSetTuneBitmap)(HBITMAP hSpec, HBITMAP hWater, HBITMAP hLevel);
FUNCHEAD void (FUNCTYPE mmsSetHDC)(HDC hSync, HDC hSpec, HDC hWater, HDC hLevel);
FUNCHEAD LONG (FUNCTYPE mmsDoJob)(LONG sw);
FUNCHEAD LONG (FUNCTYPE mmsGetLevel)(void);
FUNCHEAD LONG (FUNCTYPE mmsGetSpec)(LPLONG pStore);
FUNCHEAD LONG (FUNCTYPE mmsGetSpecDraw)(LPLONG pStore, LONG width, LONG max);
FUNCHEAD void (FUNCTYPE mmsGetSpecPersistence)(LPLONG pStore);
FUNCHEAD ULONG (FUNCTYPE mmsGetAFCFQ)(void);
FUNCHEAD LONG (FUNCTYPE mmsGetWWVFQ)(void);
FUNCHEAD void (FUNCTYPE mmsSetSpecRange)(LONG fl, LONG fw);
FUNCHEAD void (FUNCTYPE mmsSetSpecColor)(COLORREF back, COLORREF sig, COLORREF persist, COLORREF marksync, COLORREF marksig);
FUNCHEAD void (FUNCTYPE mmsSetWaterColor)(COLORREF back, COLORREF sig);
FUNCHEAD LONG (FUNCTYPE mmsGetSampleFreq)(LONG sw);
FUNCHEAD void (FUNCTYPE mmsSetSampleFreq)(LONG sw, LONG freq);
FUNCHEAD LPCSTR (FUNCTYPE mmsGetModeName)(LONG mode);
FUNCHEAD ULONG (FUNCTYPE mmsGetModeSize)(LONG mode);
FUNCHEAD ULONG (FUNCTYPE mmsGetImageSize)(LONG mode);
FUNCHEAD LONG (FUNCTYPE mmsGetModeLength)(LONG mode);
FUNCHEAD void (FUNCTYPE mmsStartScan)(LONG mode);
FUNCHEAD void (FUNCTYPE mmsStopScan)(LONG enb);
FUNCHEAD LONG (FUNCTYPE mmsGetMode)(LONG tx);
FUNCHEAD void (FUNCTYPE mmsSendPic)(LONG mode);
FUNCHEAD void (FUNCTYPE mmsSendTone)(LONG freq);
FUNCHEAD void (FUNCTYPE mmsSendStop)(void);
FUNCHEAD void (FUNCTYPE mmsSetPTT)(LONG tx);
FUNCHEAD LONG (FUNCTYPE mmsGetPos)(LONG tx);
FUNCHEAD LONG (FUNCTYPE mmsSetLMS)(LONG sw);
FUNCHEAD LONG (FUNCTYPE mmsSetRxControl)(LONG sw);
FUNCHEAD LONG (FUNCTYPE mmsSetTxControl)(LONG sw);
FUNCHEAD LONG (FUNCTYPE mmsSetTuneControl)(LONG sw);
FUNCHEAD void (FUNCTYPE mmsSetClearColor)(COLORREF col);
FUNCHEAD COLORREF (FUNCTYPE mmsGetClearColor)(void);
FUNCHEAD void (FUNCTYPE mmsReSync)(void);
FUNCHEAD void (FUNCTYPE mmsCorrectSlant)(void);
FUNCHEAD void (FUNCTYPE mmsAdjustPhase)(LONG x, LONG xw);
FUNCHEAD LPCSTR (FUNCTYPE mmsGetFSKID)(void);
FUNCHEAD LPCSTR (FUNCTYPE mmsSetFSKID)(LPCSTR pCall);
FUNCHEAD LPCSTR (FUNCTYPE mmsSetCWID)(LPCSTR pText);
FUNCHEAD void (FUNCTYPE mmsSetCWIDCallback)(CWIDPROC pFunc);
FUNCHEAD LPCSTR (FUNCTYPE mmsSetPTTPort)(LPCSTR pCom);
FUNCHEAD LPCSTR (FUNCTYPE mmsSetRadioPort)(LPCSTR pCom);
FUNCHEAD LPCSTR (FUNCTYPE mmsGetRadioFreq)(void);
FUNCHEAD LONG (FUNCTYPE mmsDisableOption)(LONG sw);
FUNCHEAD void (FUNCTYPE mmsSetRepeater)(LONG sw, LONG tone, LONG sense, LONG t1, LONG t2, LONG sq);
FUNCHEAD LONG (FUNCTYPE mmsGetRepSQ)(void);
FUNCHEAD void (FUNCTYPE mmsSendCWID)(LPCSTR pText);
FUNCHEAD LONG (FUNCTYPE mmsSetNotch)(LONG freq);
FUNCHEAD HBITMAP (FUNCTYPE mmsCreateDIB)(int xw, int yw);
FUNCHEAD LONG (FUNCTYPE mmsDeleteDIB)(HBITMAP hb);
FUNCHEAD void (FUNCTYPE mmsDrawDIBdc)(HDC hDC, LPRECT prcDest, HBITMAP hbSrc, LPRECT prcSrc, LONG smode);
FUNCHEAD void (FUNCTYPE mmsDrawDIBwnd)(HWND hWnd, LPRECT prcDest, HBITMAP hbSrc, LPRECT prcSrc, LONG smode);
FUNCHEAD void (FUNCTYPE mmsDrawDIBbmp)(HBITMAP hbDest, LPRECT prcDest, HBITMAP hbSrc, LPRECT prcSrc, LONG smode);
FUNCHEAD void (FUNCTYPE mmsDrawDCbmp)(HBITMAP hbDest, LPRECT prcDest, HDC hdcSrc, LPRECT prcSrc, LONG smode);
FUNCHEAD void (FUNCTYPE mmsDrawTransDIBdc)(HDC hDC, LONG x, LONG y, HBITMAP hbSrc, COLORREF key);
FUNCHEAD void (FUNCTYPE mmsDrawTransDIBbmp)(HBITMAP hbDest, LONG x, LONG y, HBITMAP hbSrc, COLORREF key);
FUNCHEAD void (FUNCTYPE mmsCopyDIB)(HBITMAP hbSrc);
FUNCHEAD HBITMAP (FUNCTYPE mmsPasteDIB)(void);
FUNCHEAD HBITMAP (FUNCTYPE mmsLoadDIB)(LPCSTR pName);
FUNCHEAD LONG (FUNCTYPE mmsSaveDIB)(LPCSTR pName, HBITMAP hbSrc);
FUNCHEAD void (FUNCTYPE mmsFillDIB)(HBITMAP hbDest, COLORREF col);
FUNCHEAD LONG (FUNCTYPE mmsGetDIBSize)(LPRECT prc, HBITMAP hbSrc);
FUNCHEAD HWND (FUNCTYPE mmsSetParent)(HWND hWnd);
FUNCHEAD HWND (FUNCTYPE mmsSetMessage)(HWND hWnd, ULONG msg);
FUNCHEAD LONG (FUNCTYPE mmsStrCopy)(LPSTR pDest, LONG cbSize, LPCSTR pSrc);
FUNCHEAD LONG (FUNCTYPE mmsStrWCopy)(LPWSTR pDest, LONG cwSize, LPCSTR pSrc);
FUNCHEAD ULONG (FUNCTYPE mmsGetModeTiming)(LONG mode);
#endif	/* !defined(SSTVENG_H)	*/
